/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart;

import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;

/**
 * Class representing a JFreeChart.CategoryAxis
 * 
 * @author Teemu Lempinen
 *
 */
public class CategoryAxis extends AbstractAxis {

    public CategoryAxis(ReadGraph graph, Resource axisResource) {
        super(graph, axisResource);
    }

    @Override
    public Axis getAxis() {
        axis = new org.jfree.chart.axis.CategoryAxis();
        
        if(rotate != null && rotate > 0) {
            ((org.jfree.chart.axis.CategoryAxis)axis).setCategoryLabelPositions(
                    CategoryLabelPositions.createUpRotationLabelPositions(Math.toRadians(rotate)));
        }
        
        return super.getAxis();
    }

}
