package org.simantics.jfreechart;

import java.util.Collection;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.jfreechart.chart.properties.ChartTab;
import org.simantics.jfreechart.chart.properties.bar.BarAxisTab;
import org.simantics.jfreechart.chart.properties.bar.BarGeneralPropertiesTab;
import org.simantics.jfreechart.chart.properties.bar.BarSeriesTab;
import org.simantics.jfreechart.chart.properties.bar.BarSeriesTab2;
import org.simantics.jfreechart.chart.properties.pie.PieGeneralPropertiesTab;
import org.simantics.jfreechart.chart.properties.pie.PieSeriesTab;
import org.simantics.jfreechart.chart.properties.pie.PieSeriesTab2;
import org.simantics.jfreechart.chart.properties.xyline.XYLineAxisAndVariablesTab;
import org.simantics.jfreechart.chart.properties.xyline.XYLineGeneralPropertiesTab;
import org.simantics.layer0.Layer0;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.sysdyn.JFreeChartResource;

public class ChartSelectionTabContributor {

	public static boolean contibuteTabs(ReadGraph backend, Resource r, List<ComparableTabContributor> tabs) throws DatabaseException{
		return contibuteTabs(backend, r, tabs, ChartPropertyOptions.SHOW_TIME|ChartPropertyOptions.SHOW_AXIS|ChartPropertyOptions.SHOW_VARIABLES|ChartPropertyOptions.SHOW_CHART);
	}
	public static boolean contibuteTabs(ReadGraph backend, Resource r, List<ComparableTabContributor> tabs, int options) throws DatabaseException {
		JFreeChartResource jfree = JFreeChartResource.getInstance(backend);
		if(backend.isInstanceOf(r, jfree.ChartElement)) {
            if(backend.hasStatement(r, jfree.ChartElement_component))
                r = backend.getSingleObject(r, jfree.ChartElement_component);
        }
		
		if (backend.isInstanceOf(r, jfree.Chart)) {

             Collection<Resource> plots = backend.syncRequest(new ObjectsWithType(r, Layer0.getInstance(backend).ConsistsOf, jfree.Plot));
             if(!plots.isEmpty()) {
                 Resource plot = plots.iterator().next();

                 if(backend.isInstanceOf(plot, jfree.XYPlot)) {
                     tabs.add(new ComparableTabContributor(
                             new XYLineGeneralPropertiesTab(r),
                             10,
                             r,
                             "General"));
                     if ((options&ChartPropertyOptions.SHOW_AXIS )>0 ||(options&ChartPropertyOptions.SHOW_VARIABLES)>0 )
	                     tabs.add(new ComparableTabContributor(
	                             new XYLineAxisAndVariablesTab(r),
	                             9,
	                             r,
	                             "Axis and Variables"));
                 } else if(backend.isInstanceOf(plot, jfree.CategoryPlot)) {
                     tabs.add(new ComparableTabContributor(
                             new BarGeneralPropertiesTab(r, options),
                             10,
                             r,
                             "General"));
                     if ((options&ChartPropertyOptions.SHOW_VARIABLES )>0)
	                     tabs.add(new ComparableTabContributor(
	                             new BarSeriesTab(r, options),
	                             9,
	                             r,
	                             "Variables"));
                     if ((options&ChartPropertyOptions.SHOW_AXIS )>0)
	                     tabs.add(new ComparableTabContributor(
	                             new BarAxisTab(r),
	                             8,
	                             r,
	                             "Axis"));                        
                 } else if(backend.isInstanceOf(plot, jfree.PiePlot)) {
                     tabs.add(new ComparableTabContributor(
                             new PieGeneralPropertiesTab(r, options),
                             10,
                             r,
                             "General"));
                     if ((options&ChartPropertyOptions.SHOW_VARIABLES )>0)
	                     tabs.add(new ComparableTabContributor(
	                             new PieSeriesTab(r, options),
	                             9,
	                             r,
	                             "Variables"));
                 }
                 if ((options&ChartPropertyOptions.SHOW_CHART )>0)
	                 tabs.add(new ComparableTabContributor(
	                         new ChartTab(r),
	                         1,
	                         r,
	                         "Chart"));
                
                 return true;
             } 
         }
		return false;
	}
	
	public static boolean contibuteTabs2(ReadGraph backend, Resource r, List<ComparableTabContributor> tabs) throws DatabaseException{
		return contibuteTabs2(backend, r, tabs, ChartPropertyOptions.SHOW_TIME|ChartPropertyOptions.SHOW_AXIS|ChartPropertyOptions.SHOW_VARIABLES|ChartPropertyOptions.SHOW_CHART);
	}
	
	public static boolean contibuteTabs2(ReadGraph backend, Resource r, List<ComparableTabContributor> tabs, int options) throws DatabaseException {
		JFreeChartResource jfree = JFreeChartResource.getInstance(backend);
		if(backend.isInstanceOf(r, jfree.ChartElement)) {
            if(backend.hasStatement(r, jfree.ChartElement_component))
                r = backend.getSingleObject(r, jfree.ChartElement_component);
        }
		
		if (backend.isInstanceOf(r, jfree.Chart)) {

             Collection<Resource> plots = backend.syncRequest(new ObjectsWithType(r, Layer0.getInstance(backend).ConsistsOf, jfree.Plot));
             if(!plots.isEmpty()) {
                 Resource plot = plots.iterator().next();

                 if(backend.isInstanceOf(plot, jfree.XYPlot)) {
                     tabs.add(new ComparableTabContributor(
                             new XYLineGeneralPropertiesTab(r),
                             10,
                             r,
                             "General"));
                     if ((options&ChartPropertyOptions.SHOW_AXIS )>0 ||(options&ChartPropertyOptions.SHOW_VARIABLES)>0 )
	                     tabs.add(new ComparableTabContributor(
	                             new XYLineAxisAndVariablesTab(r),
	                             9,
	                             r,
	                             "Axis and Variables"));
				} else if (backend.isInstanceOf(plot, jfree.CategoryPlot)) {
					tabs.add(new ComparableTabContributor(
                             new BarGeneralPropertiesTab(r, options),
                             10,
                             r,
                             "General"));
                     if ((options&ChartPropertyOptions.SHOW_VARIABLES)>0)
	                     tabs.add(new ComparableTabContributor(
	                             new BarSeriesTab2(r, options),
	                             9,
	                             r,
	                             "Variables"));
                     if ((options&ChartPropertyOptions.SHOW_AXIS )>0)
	                     tabs.add(new ComparableTabContributor(
	                             new BarAxisTab(r),
	                             8,
	                             r,
	                             "Axis"));                        
                 } else if(backend.isInstanceOf(plot, jfree.PiePlot)) {
                     tabs.add(new ComparableTabContributor(
                             new PieGeneralPropertiesTab(r, options),
                             10,
                             r,
                             "General"));
                     if ((options&ChartPropertyOptions.SHOW_VARIABLES)>0)
	                     tabs.add(new ComparableTabContributor(
	                             new PieSeriesTab2(r, options),
	                             9,
	                             r,
	                             "Variables"));
                 }
                 if ((options&ChartPropertyOptions.SHOW_CHART )>0)
	                 tabs.add(new ComparableTabContributor(
	                         new ChartTab(r),
	                         1,
	                         r,
	                         "Chart"));
                
                 return true;
             } 
         }
		return false;
	}
}
