package org.simantics.jdbc;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.jdbc.ontology.JDBCResource;
import org.simantics.layer0.Layer0;

/**
 * Simantics JDBC facade.
 * 
 * @author Jani Simomaa
 */
public class SimanticsJDBC {

    public static final String PROP_SIMANTICS_JDBC_PROPERTYFILE = "simantics.jdbc.propertyfile";
    public static final String PROP_SIMANTICS_JDBC_HOST         = "simantics.jdbc.host";
    public static final String PROP_SIMANTICS_JDBC_PORT         = "simantics.jdbc.port";
    public static final String PROP_SIMANTICS_JDBC_USER         = "simantics.jdbc.user";
    public static final String PROP_SIMANTICS_JDBC_PASSWORD     = "simantics.jdbc.password";
    public static final String PROP_SIMANTICS_JDBC_DATABASE     = "simantics.jdbc.database";

    public static String createJDBCSession(WriteGraph graph, String sessionGUID) throws DatabaseException {
        Resource projects = graph.getResource("http://Projects");
        Resource documentSessions = Layer0Utils.getPossibleChild(graph, projects, "DocumentSessions");
        Layer0 L0 = Layer0.getInstance(graph);
        Resource documentSession = Layer0Utils.getPossibleChild(graph, documentSessions, sessionGUID);

        String sessionId = "http://Projects/DocumentSessions/" + sessionGUID + "/__jdbc__";

        JDBCResource JDBC = JDBCResource.getInstance(graph);
        Resource jdbcSession = graph.newResource();
        graph.claim(jdbcSession, L0.InstanceOf, JDBC.Session);
        graph.claimLiteral(jdbcSession, L0.HasName, L0.NameOf, L0.String, "__jdbc__", Bindings.STRING);
        graph.claim(documentSession, L0.ConsistsOf, jdbcSession);

        @SuppressWarnings("unused")
        Variable jdbcState = Variables.getVariable(graph, jdbcSession);

        return sessionId;
    }
}
