/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.preferences;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.issues.preferences.IssuePreferences;

public final class IssuePreferenceUtil {
    public static final String PLUGIN_ID = "org.simantics.issues";

    public static IssuePreferences getDefaultPreferences() {
        return IssuePreferenceUtil.getPreferences(DefaultScope.INSTANCE);
    }

    public static IssuePreferences getPreferences() {
        return IssuePreferenceUtil.getPreferences(InstanceScope.INSTANCE);
    }

    public static IssuePreferences getPreferences(IScopeContext context) {
        IEclipsePreferences node = context.getNode(PLUGIN_ID);
        boolean enabled = node.getBoolean("issues.enabled", true);
        int maxIssuesToWrite = node.getInt("issues.batch.write.max", 1000);
        return new IssuePreferences(enabled, maxIssuesToWrite);
    }

    public static void setPreferences(IssuePreferences commons) {
        IssuePreferenceUtil._setPreferences(InstanceScope.INSTANCE, commons);
    }

    public static void flushPreferences(IssuePreferences commons) throws BackingStoreException {
        IEclipsePreferences p = IssuePreferenceUtil._setPreferences(InstanceScope.INSTANCE, commons);
        p.flush();
    }

    public static void setPreferences(IScopeContext context, IssuePreferences prefs) {
        IssuePreferenceUtil._setPreferences(context, prefs);
    }

    private static IEclipsePreferences _setPreferences(IScopeContext context, IssuePreferences prefs) {
        IEclipsePreferences node = context.getNode(PLUGIN_ID);
        node.putBoolean("issues.enabled", prefs.enabled);
        node.putInt("issues.batch.write.max", prefs.maxBatchIssuesToWrite);
        return node;
    }
}

