/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.ui.handler;

import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.utils.TagUtil;

/**
 * @author Tuukka Lehtonen
 */
public class TagAction extends Action {

    private final String virtualGraphId;
    private final String tagURI;
    private final boolean tag;
    private final List<Resource> resources;

    /**
     * @param label
     * @param image
     * @param virtualGraphId
     * @param tagURI
     * @param tag <code>true</code> to add tag, <code>false</code> to remove tag
     * @param input
     */
    public TagAction(String label, ImageDescriptor image, String virtualGraphId, String tagURI, boolean tag, List<Resource> input) {
        super(label, image);

        this.virtualGraphId = virtualGraphId;
        this.tagURI = tagURI;
        this.tag = tag;
        this.resources = input;
    }

    @Override
    public void run() {
        Session session = Simantics.peekSession();
        if (session != null)
            new TagUtil(virtualGraphId, tagURI, tag).execute(session, resources);
    }

}
