/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.ui.contribution;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.SWT;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.issues.ontology.IssueResource;

/**
 * @author Tuukka Lehtonen
 */
public enum IssueLabelDecorationRule implements LabelDecorationRule {

    INSTANCE;

    public static IssueLabelDecorationRule get() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    @Override
    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        Variable issue = (Variable) content;

        boolean hidden = false;
        boolean user = false;
        boolean resolved = false;

        Resource issueR = issue.getPossibleRepresents(graph);
        if (issueR != null) {
            IssueResource ISSUE = IssueResource.getInstance(graph);
            hidden = graph.hasStatement(issueR, ISSUE.Hidden);
            user = graph.hasStatement(issueR, ISSUE.UserIssue);
            resolved = graph.hasStatement(issueR, ISSUE.Resolved);
        } else {
            hidden = Boolean.TRUE.equals(issue.getPossiblePropertyValue(graph, "hidden", Bindings.BOOLEAN)); //$NON-NLS-1$
        }

        int index = (hidden ? 1 : 0) + (user ? 2 : 0) + (resolved ? 4 : 0);
        return DECORATORS[index];
    }

    private static final Decorator[] DECORATORS = {
            null,
            new Decorator(true, false, false),
            new Decorator(false, true, false),
            new Decorator(true, true, false),
            new Decorator(false, false, true),
            new Decorator(true, false, true),
            new Decorator(false, true, true),
            new Decorator(true, true, true),
    };

    private static class Decorator extends LabelDecorator.Stub {
        private boolean hidden;
        private boolean user;
        private boolean resolved;

        public Decorator(boolean hidden, boolean user, boolean resolved) {
            this.hidden = hidden;
            this.user = user;
            this.resolved = resolved;
        }

        @SuppressWarnings("unchecked")
        @Override
        public <F> F decorateFont(F font, String column, int itemIndex) {
            int style = 0;
            style |= resolved ? SWT.ITALIC : 0;
            //style |= hidden ? SWT.BOLD : 0;
            return style != 0 ? (F) ((FontDescriptor) font).setStyle(style) : font;
        }
        @SuppressWarnings("unchecked")
        @Override
        public <C> C decorateForeground(C color, String column, int itemIndex) {
            if (hidden)
                return (C) Constants.HIDDEN_FG;
            return color;
        }
        @SuppressWarnings("unchecked")
        @Override
        public <C> C decorateBackground(C color, String column, int itemIndex) {
            if (user)
                return (C) Constants.USER_BG;
            return color;
        }
    };

}
