/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.simantics.Simantics;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.issues.ui.ontology.IssueUIResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.views.swt.ModelledView;

/**
 * @author Antti Villberg
 */
public class IssueView2 extends ModelledView {

    @Override
    protected String configurationURI() {
        return IssueUIResource.URIs.IssueView;
    }

    @Override
    protected void inputChanged(IWorkbenchPart part, Object input) {
        //System.out.println("input: " + input);
        updateViewDescription(input);
        super.inputChanged(part, input);
    }

    private void updateViewDescription(Object input) {
        if (input instanceof Resource) {
            Resource r = (Resource) input;
            ISessionContext ctx = getSessionContext();
            if (ctx != null) {
                try {
                    String desc = ctx.getSession().syncRequest(new ResourceRead<String>(r) {
                        @Override
                        public String perform(ReadGraph graph) throws DatabaseException {
                            Resource r = resource;
                            Resource config = getConfiguration(graph, r);
                            if (config != null)
                                r = config;

                            return formName(graph, r);
                        }

                        private String formName(ReadGraph graph, Resource r) throws DatabaseException {
                            String name = NameUtils.getSafeName(graph, r);
                            final Resource project = Simantics.getProjectResource();
                            String projectUri = project != null ? graph.getPossibleURI(project) : ""; //$NON-NLS-1$
                            String uri = graph.getPossibleURI(r);
                            if (uri != null) {
                                if (uri.startsWith(projectUri))
                                    uri = uri.substring(projectUri.length());
                            }
                            return uri != null ? name + " (" + uri + ")" : name; //$NON-NLS-1$ //$NON-NLS-2$
                        }

                        private Resource getConfiguration(ReadGraph graph, Resource r) throws DatabaseException {
                            DiagramResource DIA = DiagramResource.getInstance(graph);
                            Resource diagram = graph.getPossibleObject(r, DIA.RuntimeDiagram_HasConfiguration);
                            if (diagram == null)
                                return r;
                            ModelingResources MOD = ModelingResources.getInstance(graph);
                            Resource config = graph.getPossibleObject(diagram, MOD.DiagramToComposite);
                            if (config == null)
                                return diagram;
                            return config;
                        }
                    });
                    setContentDescription(desc);
                } catch (DatabaseException e) {
                    setContentDescription(e.getMessage());
                }
            }
            setVisible(true);
        } else {
            setContentDescription(Messages.IssueView2_IssuesNotAvailable);
            setVisible(false);
        }
    }

    @Override
    protected IPropertyPage getPropertyPage() {
        //return new PropertyPage(getSite());
        return null;
    }

    @SuppressWarnings({ "unchecked", "deprecation" })
    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (GraphExplorer.class == adapter)
            return (T) tryGetExplorer(container);
        if (BrowseContext.class == adapter)
            return (T) tryGetBrowseContext(container);
        return super.getAdapter(adapter);
    }

    private BrowseContext tryGetBrowseContext(Control control) {
        return SWTUtils.tryGetObject(control, c -> {
            return c instanceof IAdaptable
                    ? (BrowseContext) ((IAdaptable) c).getAdapter(BrowseContext.class)
                            : null;
        });
    }

    private GraphExplorer tryGetExplorer(Control control) {
        return SWTUtils.tryGetObject(control, c -> {
            return c.isDisposed() ? null
                    : (GraphExplorer) c.getData(GraphExplorer.KEY_GRAPH_EXPLORER);
        });
    }

}
