/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;

import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

public class WarningIssues extends BinaryRead<Resource, Boolean, Set<Variable>> {

    public WarningIssues(Resource resource) {
        super(resource, Boolean.FALSE);
    }

    public WarningIssues(Resource resource, boolean onlyUnresolved) {
        super(resource, onlyUnresolved);
    }

    @Override
    public Set<Variable> perform(ReadGraph graph) throws DatabaseException {
        Set<Variable> result = new THashSet<Variable>();
        for (Variable issue : graph.syncRequest(new AllVisibleIssues(parameter, parameter2))) {
            if ("Warning".equals(issue.getPossiblePropertyValue(graph, "severity")))
                result.add(issue);
        }
        return result;
    }

}
