/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;

import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.Model;
import org.simantics.db.layer0.variable.Variable;

/**
 * @author Antti Villberg
 */
public class IssuesWithContext extends ResourceRead2<Set<Variable>> {

    public IssuesWithContext(ReadGraph graph, Resource context) throws DatabaseException {
        super(graph.sync(new Model(context)), context);
    }

    public IssuesWithContext(Resource model, Resource context) {
        super(model, context);
    }

    @Override
    public Set<Variable> perform(ReadGraph graph) throws DatabaseException {
    	
        Set<Variable> result = new THashSet<Variable>();
        for(Resource issue : graph.sync(new AllModelIssues(resource))) {
            Set<Resource> contexts = graph.sync(new IssueResourceContexts(issue));
            if(contexts.contains(resource2)) result.add(graph.adapt(issue, Variable.class)); 
        }
        return result;
        
    }

}
