/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;

import java.util.Collection;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.ontology.IssueResource;

/**
 * A request for calculating the set of issue context resources for the
 * specified collection of issue resources.
 * 
 * @author Tuukka Lehtonen
 */
public class IssueResourcesContexts extends UnaryRead<Collection<Resource>, Set<Resource>> {

    public IssueResourcesContexts(Collection<Resource> issues) {
        super(issues);
    }

    @Override
    public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance(graph);
        Set<Resource> result = new THashSet<Resource>();
        for(Resource issue : parameter) {
            result.addAll(graph.getObjects(issue, ISSUE.Issue_HasContext));
            Resource list = graph.getPossibleObject(issue, ISSUE.Issue_HasContexts);
            if(list != null) result.addAll(ListUtils.toList(graph, list));
        }
        return result;
    }

}
