/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;

import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.issues.ontology.IssueResource;

/**
 * A request for calculating the set of issue context resources for the
 * specified set of issue variables.
 * 
 * @author Tuukka Lehtonen
 */
public class IssueContexts extends UnaryRead<Set<Variable>, Set<Resource>> {

    public IssueContexts(Set<Variable> variables) {
        super(variables);
    }

    @Override
    public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance(graph);
        Set<Resource> result = new THashSet<Resource>(parameter.size());
        for(Variable issue : parameter) {
        	Resource issueResource = issue.getRepresents(graph);
            result.addAll(graph.getObjects(issueResource, ISSUE.Issue_HasContext));
            Resource list = graph.getPossibleObject(issueResource, ISSUE.Issue_HasContexts);
            if(list != null) result.addAll(ListUtils.toList(graph, list));
        }
        return result;
    }

}
