/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.image.ui;

 import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.utils.FileUtils;
import org.simantics.utils.ui.AdaptionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class ImportImagesActionFactory implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        final Resource container = AdaptionUtils.adaptToSingle(target, Resource.class);
        if (container == null)
            return null;

        return new Runnable() {
            @Override
            public void run() {
                IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (win == null)
                    return;
                Collection<File> files = requestImportedImages(win.getShell());
                if (files.isEmpty())
                    return;

                Simantics.getSession().markUndoPoint();
                Simantics.getSession().asyncRequest( new CreateImages(container, files) );
            }
        };
    }

    public static Collection<File> requestImportedImages(Shell parentShell) {
        FileDialog dialog = new FileDialog(parentShell, SWT.MULTI);
        dialog.setText(Messages.ImportImagesActionFactory_ChooseImageToBeImported);
        dialog.setFilterExtensions( new String[] {"*.jpg;*.png;*.gif;*.svg", "*.jpg;*.jpeg", "*.png", "*.gif", "*.svg"} ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
        dialog.setFilterNames( new String[] {Messages.ImportImagesActionFactory_FilterAllImage, Messages.ImportImagesActionFactory_FilterJPEGImage, Messages.ImportImagesActionFactory_FilterPNGImage, Messages.ImportImagesActionFactory_FilterGIFImages, Messages.ImportImagesActionFactory_FilterSVGImage} );
        //dialog.setFilterExtensions( new String[] {"*.jpg", "*.png", "*.gif"} );
        final String filename = dialog.open();
        if (filename == null)
            return Collections.emptyList();
        String[] files = dialog.getFileNames();
        File parent = new File(dialog.getFilterPath());
        ArrayList<File> result = new ArrayList<File>(files.length);
        for (String file : files)
            result.add( new File(parent, file) );
        return result;
    }

    public static ImageSource toImageSource(File file) throws IOException {
        ImageSource src = new ImageSource();
        src.name = file.getName();
        src.data = FileUtils.readFile(file);
        return src;
    }

}
