/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.help.ui;

import java.util.function.Supplier;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.combinations.Combinators;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.help.ui.HelpFileDocumentProvider;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorSupport;
import org.simantics.ui.workbench.TitleUpdater;
import org.simantics.ui.workbench.TitleWithParentNameRequest;
import org.simantics.ui.workbench.ToolTipRequest;
import org.simantics.ui.workbench.editor.input.InputValidationCombinators;
import winterwell.markdown.editors.MarkdownEditor;

public class HelpFileEditor
extends MarkdownEditor {
    private static final String EDITOR_ID = "org.simantics.help.ui.HelpFileEditor";
    private boolean disposed;
    private static final ParametrizedRead<IResourceEditorInput, Boolean> INPUT_VALIDATOR = Combinators.compose((ParametrizedRead)InputValidationCombinators.hasURI(), (ParametrizedRead)InputValidationCombinators.extractInputResource());
    private ResourceEditorSupport support;

    public HelpFileEditor() {
        this.setDocumentProvider((IDocumentProvider)new HelpFileDocumentProvider());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.support = new ResourceEditorSupport((IEditorPart)this, INPUT_VALIDATOR);
        this.support.activateValidation();
        try {
            this.getResourceInput().init(null);
        }
        catch (DatabaseException e) {
            throw new PartInitException("Failed to initialize " + input, (Throwable)e);
        }
    }

    protected IResourceEditorInput getResourceInput() {
        return (IResourceEditorInput)this.getEditorInput();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.updatePartName();
    }

    protected void updatePartName() {
        this.setPartName(this.getEditorInput().getName());
        Session session = Simantics.peekSession();
        if (session != null) {
            Supplier<Boolean> disposedCallback = this::isDisposed;
            session.asyncRequest((Read)new TitleWithParentNameRequest(this.getResourceInput()), (Listener)new TitleUpdater(this.getSite().getShell().getDisplay(), arg_0 -> ((HelpFileEditor)this).setPartName(arg_0), disposedCallback));
            session.asyncRequest((Read)new ToolTipRequest(this.getSite().getId(), this.getResourceInput()), (Listener)new TitleUpdater(this.getSite().getShell().getDisplay(), arg_0 -> ((HelpFileEditor)this).setTitleToolTip(arg_0), disposedCallback));
        }
    }

    public void dispose() {
        this.disposed = true;
        if (this.support != null) {
            this.support.dispose();
            this.support = null;
        }
        super.dispose();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public static String getEditorId() {
        return EDITOR_ID;
    }
}

