/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphviz.internal.xdot;

import java.awt.Color;
import java.awt.Graphics2D;

public class SetFillColor implements DrawCommand {

    private static ThreadLocal<Color> fillColor =
        new ThreadLocal<Color>();
    
	Color color;
	
	public SetFillColor(String colorName) {
	    color = Colors.getColor(colorName);
	}

	@Override
	public void draw(Graphics2D g) {
		fillColor.set(color);
	}
	
	public static Color getFillColor() {
	    Color ret = fillColor.get();
	    if(ret == null)
	        return Color.BLACK;
	    return ret;
	}

}
