/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphviz;

/**
 * Default implementation for Identifiable and IGraphPart.
 * 
 * @author Hannu Niemist
 */
public abstract class AbstractIdentifiableGraphPart extends AbstractGraphPart implements Identifiable {

    String id;
    
    public AbstractIdentifiableGraphPart(IGraph parent) {
        super(parent);
        this.id = parent.newId();
    }

    @Override
    public String getId() {
        return id;
    }

}
