/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphviz;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

/**
 * Default implementation for IAttributeContainer.
 * 
 * @author Hannu Niemist
 */
public class AbstractAttributeContainer implements IAttributeContainer {

    Map<String,String> attributes = new HashMap<String,String>();
    
    public void set(String key, String value) {
        attributes.put(key, value);
    }
    
    public String get(String key) {
        return attributes.get(key);
    }
    
    protected void writeAttributes(PrintStream s) {
        s.print(" [");
        boolean first = true;
        for(Map.Entry<String, String> ent : attributes.entrySet()) {
            String key = ent.getKey();
            String value = ent.getValue();
            if(first)
                first = false;
            else
                s.print(' ');
            s.print(key);
            if(!value.isEmpty() && value.charAt(0) == '<' && value.charAt(value.length()-1) == '>') {
            	s.print('=');
            	s.print(value);
            }
            else {
	            s.print("=\"");
	            s.print(escape(value));
	            s.print('\"');
            }
        }
        s.println("];");
    }
    
    static String escape(String str) {
        str = str.replace("\"", "\\\"");
        return str;
    }
    
}
