/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graph.tests;

import org.junit.Test;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.type.Datatype;
import org.simantics.graph.utils.TGResourceUtil;
import org.simantics.graph.utils.TGResourceUtil.LongAdapter;

public class TestResourceUtil2 {

	
	public @Test void test() throws Exception {
	
	    try {
	
	        Datatype dt = Datatypes.translate("RecordType {metadata = {}, components = [{name = \"configuration\", type = UnionType {metadata = {}, components = [{name = \"AprosComposite\", type = RecordType {metadata = {}, components = [{name = \"resourceId\", type = LongType {metadata = {}}}, {name = \"childMap\", type = MapType {metadata = {}, keyType = StringType {metadata = {}}, valueType = UnionType a}}, {name = \"sourceTypeUri\", type = OptionalType {metadata = {}, componentType = StringType {metadata = {}}}}]}}, {name = \"AprosComponent\", type = RecordType {metadata = {}, components = [{name = \"resourceId\", type = LongType {metadata = {}}}, {name = \"moduleId\", type = IntegerType {metadata = {}}}, {name = \"parametrized\", type = BooleanType {metadata = {}}}]}}]}/a}, {name = \"currentRevision\", type = LongType {metadata = {}}}]}");
	        Binding b = Bindings.getBinding(dt);
	        Object value = b.createDefault();
	        Variant variant = new Variant(b, value);
	        TGResourceUtil util = new TGResourceUtil();
	        LongAdapter la = new LongAdapter() {
	            @Override
	            public long adapt(long in) {
	                return in;
	            }            
	        };
	        util.adaptValue( variant.getBinding(), variant.getValue(), la );                        
	
	    } catch (DataTypeSyntaxError e) {
	        e.printStackTrace();
	    } catch (BindingException e) {
	        e.printStackTrace();
	    } catch (RuntimeSerializerConstructionException e) {
	        e.printStackTrace();
	    } catch (AccessorException e) {
	        e.printStackTrace();
	    }
    
	}
	
}
