package org.simantics.graph.compiler.internal.values;

import java.util.Collection;

import org.antlr.runtime.tree.Tree;
import org.simantics.databoard.binding.Binding;
import org.simantics.graph.compiler.internal.ltk.ISource;
import org.simantics.graph.compiler.internal.ltk.Location;
import org.simantics.graph.compiler.internal.ltk.Problem;
import org.simantics.graph.compiler.internal.ltk.antlr.ANTLRUtils;
import org.simantics.graph.compiler.internal.parsing.GraphParser;
import org.simantics.graph.compiler.internal.store.IPreValue;
import org.simantics.graph.compiler.internal.translation.DataValueTranslator;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.Paths;

public class TreeValue implements IPreValue {

	ISource source;
	Tree tree;
	
	public TreeValue(ISource source, Tree tree) {
		this.source = source;
		this.tree = tree;
	}

	@Override
	public Object toValue(Binding binding, Collection<Problem> problems) {
		return new DataValueTranslator(source, problems).translate(tree, binding);
	}

	public Tree getTree() {
		return tree;
	}

	@Override
	public Path getDefaultType(Paths paths) {
		Tree b = this.tree;
		while(b.getType() == GraphParser.TUPLE && b.getChildCount() == 1)
			b = b.getChild(0);
		
		switch(b.getType()) {
		case GraphParser.INT:     return paths.Integer;
		case GraphParser.FLOAT:   return paths.Double;
		case GraphParser.STRING:  return paths.String;
		case GraphParser.TRUE:
		case GraphParser.FALSE:   return paths.Boolean;
		case GraphParser.VARIANT: return paths.Variant;
		case GraphParser.ARRAY:
			if(b.getChildCount() > 0) {
				switch(b.getChild(0).getType()) {
				case GraphParser.INT:
				case GraphParser.FLOAT:
					for(int i=0;i<b.getChildCount();++i)
						if(b.getChild(i).getType() == GraphParser.FLOAT)
							return paths.DoubleArray;
					return paths.IntegerArray;
				case GraphParser.STRING:
					return paths.StringArray;
				case GraphParser.TRUE:
				case GraphParser.FALSE:
					return paths.BooleanArray;
				}
			}
		}
		return null;
	}

	@Override
	public Location getLocation() {
		return ANTLRUtils.location(source, tree);
	}
	
	@Override
	public String toString() {
		return tree.getText();
	}
}
