/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.chassis;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.chassis.ICanvasChassis;
import org.simantics.g2d.chassis.IChassisListener;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SyncListenerList;

public abstract class AbstractChassis
implements ICanvasChassis {
    protected IHintContext hintCtx = new HintContext();
    protected SyncListenerList<IChassisListener> listeners = new SyncListenerList(IChassisListener.class);
    protected ICanvasContext canvasContext;

    @Override
    public void setCanvasContext(ICanvasContext canvasContext) {
        assert (this.canvasContext == null);
        assert (canvasContext != null);
        this.canvasContext = canvasContext;
        canvasContext.getHintStack().addHintContext(this.hintCtx, 0);
    }

    @Override
    public ICanvasContext getCanvasContext() {
        return this.canvasContext;
    }

    @Override
    public void addChassisListener(IThreadWorkQueue thread, IChassisListener listener) {
        this.listeners.add(thread, (Object)listener);
    }

    @Override
    public void removeChassisListener(IThreadWorkQueue thread, IChassisListener listener) {
        this.listeners.remove(thread, (Object)listener);
    }

    @Override
    public void addChassisListener(IChassisListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeChassisListener(IChassisListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public IHintContext getHintContext() {
        return this.hintCtx;
    }
}

