/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.tooltip;

import org.simantics.g2d.element.IElement;

/**
 * Interface for creating tool-tips
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public interface TooltipProvider {
	/**
	 * Shows tooltip in given screen coordinates
	 * @param element
	 * @param x
	 * @param y
	 */
	void showTooltip(IElement element, int x, int y);
	
	/**
	 * Hides the tooltip
	 * @param element
	 */
	void hideTooltip(IElement element);

}
