/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.scenegraph;

import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.GridNode;

/**
 * Scene graph related constants for the G2D framework.
 * 
 * @author Tuukka Lehtonen
 */
public final class SceneGraphConstants {

    /**
     * The event handler priority of {@link G2DSceneGraph} in a
     * {@link CanvasContext}.
     */
    public static final int      SCENEGRAPH_EVENT_PRIORITY = Integer.MAX_VALUE - 1;

    public static final String   NAVIGATION_NODE_NAME      = "navigation";

    public static final String[] NAVIGATION_NODE_PATH      = { NAVIGATION_NODE_NAME };

    public static final String   DATA_NODE_NAME            = "data";

    public static final String[] DATA_NODE_PATH            = { DATA_NODE_NAME };

    public static final String   GRID_NODE_NAME            = GridNode.GRID_NODE_ID;

    public static final String   SELECTIONS_NODE_NAME      = "selections";

    public static final String[] SELECTIONS_NODE_PATH      = { DATA_NODE_NAME, SELECTIONS_NODE_NAME };

    public static final String   SPATIAL_ROOT_NODE_NAME    = "spatialRoot";

    public static final String   SPATIAL_ROOT_NODE_ID      = SPATIAL_ROOT_NODE_NAME;

}
