/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.participant;

import java.awt.GraphicsConfiguration;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.image.Image;
import org.simantics.utils.datastructures.cache.IProvider;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * Utility participant used for acquiring and storing symbols.
 * 
 * //@deprecated
 * //TODO: Toni, explain why this is deprecated ??
 * @author Toni Kalajainen
 */
public class SymbolUtil extends AbstractCanvasParticipant {

    static class SymbolKey extends Key {
        public final IProvider<Image> provider;
        public final GraphicsConfiguration gc;
        private final int hash;
        public SymbolKey(GraphicsConfiguration gc,
                IProvider<Image> provider) {
            assert(gc!=null && provider!=null);
            this.gc = gc;
            this.provider = provider;
            this.hash = gc.hashCode() ^provider.hashCode();
        }
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof SymbolKey)) return false;
            SymbolKey other = (SymbolKey) obj;
            if (!other.provider.equals(provider)) return false;
            if (!other.gc.equals(gc)) return false;
            return true;
        }
        @Override
        public int hashCode() {
            return hash;
        }
        @Override
        public boolean isValueAccepted(Object value) {
            return value instanceof Image;
        }
    }

    HintContext hintCtx = new HintContext();

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        hintCtx = null;
        super.removedFromContext(ctx);
    }

    /**
     * Acquire and store symbol.
     * 
     * @param provider
     * @param gc
     * @return
     */
    public Image get(IProvider<Image> provider, GraphicsConfiguration gc) {
        SymbolKey key = new SymbolKey(gc, provider);
        Image ps = hintCtx.getHint(key);
        if (ps!=null) return ps;
        ps = provider.get();
        hintCtx.setHint(key, ps);
        return ps;
    }

}
