/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.g2d.image;

import org.simantics.utils.datastructures.cache.IFactory;


/**
 * This class contains some built-in images.
 * 
 * Usage example.
 * 
 *  Image x = DefaultImages.UNKNOWN.get();
 *  x.paint();
 *  ...
 *  x = null;
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class DefaultImages {	
	
	public static final IFactory<Image> UNKNOWN2 = get("unknown.png");
	public static final IFactory<Image> SVG = get("svg.png");
    public static final IFactory<Image> ERROR_DECORATOR = get("error.svg");
    public static final IFactory<Image> WARNING_DECORATOR = get("warningDecorator.png");
	public static final IFactory<Image> COMPOSITION = get("composition.png");
	public static final IFactory<Image> UNKNOWN = get("unknownDocument.svg");
	public static final IFactory<Image> WHEEL =  get("wheel2.svg");	
	public static final IFactory<Image> GRAB = get("grab.png");
	public static final IFactory<Image> GRAB32 = get("grab32.png");
	public static final IFactory<Image> HAND = get("hand.png");
	public static final IFactory<Image> HAND32 = get("hand32.png");
	public static final IFactory<Image> HOURGLASS = get("hourglass.svg");

	private static IFactory<Image> get(String filename) {
		return 
			ProviderUtils.reference(
			ProviderUtils.cache(
			ProviderUtils.rasterize(
			ProviderUtils.at(
				DefaultImages.class.getResource(filename)
			))));		
	}
	
}
