/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.elementclass.connection;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Path2DOutlineShape implements Shape {

	Path2D path;
	
	public Path2DOutlineShape(Path2D path) {
		this.path = path;
	}

	@Override
	public boolean contains(Point2D p) {
		return false;
	}

	@Override
	public boolean contains(Rectangle2D r) {
		return false;
	}

	@Override
	public boolean contains(double x, double y) {		
		return false;
	}

	@Override
	public boolean contains(double x, double y, double w, double h) {		
		return false;
	}

	@Override
	public Rectangle getBounds() {
		return path.getBounds();
	}

	@Override
	public Rectangle2D getBounds2D() {
		return path.getBounds2D();
	}

	@Override
	public PathIterator getPathIterator(AffineTransform at) {
		return path.getPathIterator(at);
	}

	@Override
	public PathIterator getPathIterator(AffineTransform at, double flatness) {
		return path.getPathIterator(at, flatness);
	}

	@Override
	public boolean intersects(Rectangle2D r) {
		return intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
	}

	@Override
	public boolean intersects(double x, double y, double w, double h) {
		PathIterator it = path.getPathIterator(new AffineTransform(), 1.0);
		double[] coords = new double[2];
		double x0, y0, x1=0.0, y1=0.0;
		while(!it.isDone()) {
			x0 = x1;
			y0 = y1;
			switch(it.currentSegment(coords)) {
			case PathIterator.SEG_MOVETO:
				x1 = coords[0];
				y1 = coords[1];
				break;
				
			case PathIterator.SEG_LINETO:
				x1 = coords[0];
				y1 = coords[1];
				
				// Lines are approximated by their bounding boxes. This works for
				// orthogonal paths.
				if(x0 < x1) {
					if(x > x1 || x+w < x0)
						break;						
				}
				else {
					if(x > x0 || x+w < x1)
						break;
				}

				if(y0 < y1) {
					if(y > y1 || y+h < y0)
						break;						
				}
				else {
					if(y > y0 || y+h < y1)
						break;
				}	
				return true;
			}			
			it.next();
		}
		return false;
	}
	
}
