/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.elementclass;

import org.simantics.g2d.element.ElementClass.Single;
import org.simantics.g2d.element.handler.ElementHandler;

/**
 * A tagging element handler for telling whether an element can be considered a
 * reference element. This means that the element is not a direct representation of
 * what it references and the life cycle of the referenced object does not depend
 * on the life cycle of this element.
 * 
 * This is used as a guiding for diagram copy paste.
 * 
 * @author Tuukka Lehtonen
 */
@Single
public interface ReferenceElement extends ElementHandler {

	ReferenceElement INSTANCE = new ReferenceElement() {
		private static final long serialVersionUID = 305657929840186623L;
	};

}
