/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import java.awt.Shape;
import java.awt.geom.AffineTransform;

import org.simantics.g2d.diagram.handler.Topology.Terminal;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.TerminalLayout;
import org.simantics.g2d.utils.geom.DirectionSet;

/**
 * @author Toni Kalajainen
 */
public class ProxyTerminalHandler implements TerminalLayout {

    private static final long serialVersionUID = 219568974959605233L;

    TerminalLayout orig;
    IProxyProvider provider;

    public ProxyTerminalHandler(IProxyProvider provider, TerminalLayout orig) {
        this.provider = provider;
        this.orig = orig;
    }

    @Override
    public AffineTransform getTerminalPosition(IElement node, Terminal t) {
        return orig.getTerminalPosition(provider.provide(node), t);
    }

    @Override
    public boolean getTerminalDirection(IElement node, Terminal t, DirectionSet directions) {
        return orig.getTerminalDirection(node, t, directions);
    }

    @Override
    public Shape getTerminalShape(IElement node, Terminal t) {
        return orig.getTerminalShape(node, t);
    }

}
