/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import org.simantics.g2d.diagram.handler.Topology.Terminal;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.TerminalData;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * A straight-forward implementation of the {@link TerminalData} element handler
 * interface. It uses an element's hint context to store a separate HintContext
 * for terminals.
 * 
 * @author Tuukka Lehtonen
 */
public class TerminalDataImpl implements TerminalData {

    private static final long serialVersionUID = -2131030904280472077L;

    public static final TerminalDataImpl INSTANCE = new TerminalDataImpl();

    static class TerminalKey extends KeyOf {
        private final Terminal terminal;
        public TerminalKey(Terminal terminal) {
            super(IHintContext.class);
            if (terminal == null)
                throw new NullPointerException("null terminal");
            this.terminal = terminal;
        }
        @Override
        public int hashCode() {
            return terminal.hashCode();
        }
        @Override
        public boolean equals(Object obj) {
            if (this == obj)
                return true;
            if (!(obj instanceof TerminalKey))
                return false;
            TerminalKey other = (TerminalKey) obj;
            return terminal.equals(other.terminal);
        }
        @Override
        public String toString() {
            return "TERMINAL_DATA(" + terminal + ")";
        }
    }

    @Override
    public <T> T getHint(IElement e, Terminal t, Key key) {
        IHintContext context = e.getHint(new TerminalKey(t));
        if (context == null)
            return null;
        return context.getHint(key);
    }

    @Override
    public void setHint(IElement e, Terminal t, Key key, Object value) {
        Key terminalKey = new TerminalKey(t);
        IHintContext context = e.getHint(terminalKey);
        if (context == null) {
            context = new HintContext();
            e.setHint(terminalKey, context);
        }
        context.setHint(key, value);
    }

}
