/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.Color;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.FillColor;
import org.simantics.g2d.element.handler.LifeCycle;

/**
 * 
 * @See {@link Color}
 * @author Toni Kalajainen
 */
public class FillColorImpl implements FillColor, LifeCycle {

	private static final long serialVersionUID = 2241631816115855117L;
	public static final FillColorImpl UNSET = new FillColorImpl(null);
	public static final FillColorImpl BLACK = new FillColorImpl(java.awt.Color.BLACK);
	public static final FillColorImpl WHITE = new FillColorImpl(java.awt.Color.WHITE);
	public static final FillColorImpl RED = new FillColorImpl(java.awt.Color.RED);
	public static final FillColorImpl BLUE = new FillColorImpl(java.awt.Color.BLUE);
		
	public synchronized static FillColorImpl handlerOf(java.awt.Color c)
	{
		return new FillColorImpl(c);
	}
	
	java.awt.Color defaultColor = java.awt.Color.BLACK;
	
	public FillColorImpl() {}
	public FillColorImpl(java.awt.Color defaultColor) {
		this.defaultColor = defaultColor;
	}
	
	@Override
	public java.awt.Color getFillColor(IElement e) {		
		return e.getHint(ElementHints.KEY_FILL_COLOR);
	}

	@Override
	public void setFillColor(IElement e, java.awt.Color c) {
		e.setHint(ElementHints.KEY_FILL_COLOR, c);
	}
	
	@Override
	public void onElementActivated(IDiagram d, IElement e) {
	}
	@Override
	public void onElementCreated(IElement e) {
		if (defaultColor!=null)
			e.setHint(ElementHints.KEY_FILL_COLOR, defaultColor);
	}
	@Override
	public void onElementDeactivated(IDiagram d, IElement e) {
	}
	@Override
	public void onElementDestroyed(IElement e) {
	}
}
