/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;

import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.SelectionOutline;

public class ConnectionSelectionOutline implements SelectionOutline {

    private static final long                      serialVersionUID = 1L;

    public final static ConnectionSelectionOutline INSTANCE         = new ConnectionSelectionOutline();

    public static final Stroke                    defaultStroke    = new BasicStroke(0.3f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_BEVEL);

    public Stroke resolveStroke(IElement e, Stroke defaultValue) {
        for (EdgeVisuals ev : e.getElementClass().getItemsByClass(EdgeVisuals.class)) {
            BasicStroke stroke = (BasicStroke) ev.getStroke(e);
            if (stroke != null) {
//                return stroke;
                return new BasicStroke(1.5f*stroke.getLineWidth(), BasicStroke.CAP_BUTT, BasicStroke.JOIN_BEVEL);
            }
        }
        return defaultStroke;
    }

    @Override
    public Shape getSelectionShape(IElement e) {
        Stroke stroke = resolveStroke(e, defaultStroke);
        Shape es = ElementUtils.getElementShapeOrBounds(e);
        return stroke.createStrokedShape(es);
    }

}
