/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.connection.ConnectionEntity;
import org.simantics.g2d.connection.IConnectionAdvisor;
import org.simantics.g2d.element.handler.EdgeVisuals.ArrowType;
import org.simantics.g2d.element.handler.EdgeVisuals.StrokeType;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.utils.Alignment;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.color.ColorFilter;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * @author Toni Kalajainen
 */
public class ElementHints {

    /**
     * For attaching a paintable scene graph node to a diagram element.
     */
    public static final Key KEY_SG_NODE = new SceneGraphNodeKey(Node.class, "SG_NODE");

    /**
     * For attaching a callback to an element that is invoked when KEY_SG_NODE
     * is initialized and set.
     */
    public static final Key KEY_SG_CALLBACK = new SceneGraphNodeKey(Consumer.class, "SG_NODE_CALLBACK");

    /**
     * For describing the local affine transformation of an element.
     */
    public static final Key KEY_TRANSFORM = new KeyOf(AffineTransform.class, "TRANSFORM");

    /**
     * For describing representation parameters of an element.
     */
    public static final Key KEY_PARAMETERS = new KeyOf(Map.class, "PARAMETERS");

    /**
     * For defining the rectangular boundaries of an element.
     */
    public static final Key KEY_BOUNDS = new KeyOf(Rectangle2D.class, "BOUNDS");

    /**
     * For defining the parent element of an element to create element hierarchy
     * in otherwise flat diagrams.
     */
    public static final Key KEY_PARENT_ELEMENT = new KeyOf(IElement.class, "PARENT_ELEMENT");

    /**
     * A collection of {@link SceneGraph} instances. Used for decorating the
     * owner element. Run-time decorators are not touched by back-end
     * synchronization, they are controlled purely from the diagram run-time
     * code. If modified, the {@link Hints#KEY_DIRTY} hint should be set with
     * the value {@link Hints#VALUE_SG_DIRTY} to update the scenegraph of the
     * element.
     * 
     * @deprecated diagram profile styles should be used instead
     */
    public static final Key KEY_DECORATORS = new KeyOf(Collection.class, "DECORATORS");

    public static final Key KEY_ANCHOR = new KeyOf(IElement.class, "ANCHOR");

    public static final Key KEY_TEXT = new KeyOf(String.class, "TEXT");
    public static final Key KEY_FONT = new KeyOf(Font.class, "FONT");

    public static final Key KEY_TEXT_COLOR = new KeyOf(Color.class, "TEXT_COLOR");
    public static final Key KEY_BORDER_COLOR = new KeyOf(Color.class, "BORDER_COLOR");
    public static final Key KEY_FILL_COLOR = new KeyOf(Color.class, "FILL_COLOR");
    public static final Key KEY_ADDITIONAL_COLOR = new KeyOf(Color.class, "ADDITIONAL_COLOR");
    public static final Key KEY_STROKE = new KeyOf(Stroke.class, "STROKE");

    public static final Key KEY_ENABLED = new KeyOf(Boolean.class, "ENABLED");

    public static final Key KEY_EDGE_STROKE = new KeyOf(Stroke.class, "EDGE_STROKE");
    public static final Key KEY_EDGE_STROKE_TYPE = new KeyOf(StrokeType.class, "EDGE_STROKE_TYPE");
    public static final Key KEY_BEGIN_ARROW = new KeyOf(ArrowType.class, "BEGIN_ARROW");
    public static final Key KEY_END_ARROW = new KeyOf(ArrowType.class, "END_ARROW");
    public static final Key KEY_BEGIN_ARROW_SIZE = new KeyOf(Double.class, "BEGIN_ARROW_SIZE");
    public static final Key KEY_END_ARROW_SIZE = new KeyOf(Double.class, "END_ARROW_SIZE");

    /** Source of data in external data model */
    public static final Key KEY_OBJECT = new KeyOf(Object.class, "OBJECT");
    public static final Key KEY_TYPE_CLASS = new KeyOf(String.class, "TYPE_CLASS");

    /**
     * Used for identifying elements that should be ignored in all matters
     * concerning rendering/measuring/interaction.
     */
    public static final Key KEY_HIDDEN = new KeyOf(HideState.class, "HIDDEN");

    /**
     * Used for specifying the name prefix of the scene graph node to generate
     * for the owner element. See {@link ElementUtils#generateNodeId(IElement)}.
     */
    public static final Key KEY_SG_NAME = new KeyOf(String.class, "SG_NAME");

    /** Points to the external data model object which this element is a copy of. */
    public static final Key KEY_COPY_OF_OBJECT = new KeyOf(Object.class, "COPY_OF_OBJECT");

    /** Value of a widget */
    public static final Key KEY_VALUE = new KeyOf(Double.class, "VALUE");
    public static final Key KEY_MIN_VALUE = new KeyOf(Double.class, "MIN_VALUE");
    public static final Key KEY_MAX_VALUE = new KeyOf(Double.class, "MAX_VALUE");

    /** Is widget locked (unusable) */
    public static final Key KEY_LOCKED = new KeyOf(Boolean.class, "LOCKED");

    public static final Key KEY_SELECTED = new KeyOf(Boolean.class, "SELECTED");

    /** Is mouse cursor on top of element **/ 
    public static final Key KEY_HOVER = new KeyOf(Boolean.class, "HOVER");
    
    /** Can the element be resized **/
    public static final Key KEY_RESIZABLE = new KeyOf(Boolean.class, "RESIZABLE");    

    public static final Key KEY_IMAGE = new KeyOf(Image.class, "IMAGE");

    /**
     * Composition rule for element painting. If this hint is found from an
     * element, it should be applied before painting the element. The only
     * implementation of {@link Composite} is {@link AlphaComposite} so that
     * should be used.
     */
    public static final Key KEY_COMPOSITE = new KeyOf(Composite.class, "COMPOSITE");

    /**
     * An optional type hint for a connection to be created. This hint is used
     * for storing something returned by
     * {@link IConnectionAdvisor#canBeConnected(Object, IElement, org.simantics.g2d.diagram.handler.Topology.Terminal, IElement, org.simantics.g2d.diagram.handler.Topology.Terminal)}
     */
    public static final Key KEY_CONNECTION_TYPE = new KeyOf(Object.class, "CONNECTION_TYPE");

    public static final Key KEY_HORIZONTAL_ALIGN = new KeyOf(Alignment.class, "HORIZONTAL_ALIGN");

    public static final Key KEY_VERTICAL_ALIGN   = new KeyOf(Alignment.class, "VERTICAL_ALIGN");

    /**
     * For storing a connection entity within each connection and connection
     * part element.
     */
    public static final Key KEY_CONNECTION_ENTITY = new KeyOf(ConnectionEntity.class, "CONNECTION_ENTITY");

    /**
     * A set of ILayer instances identifying the layers the element containing
     * this hint can be considered to be visible on.
     */
    public static final Key KEY_VISIBLE_LAYERS = new KeyOf(Set.class, "VISIBLE_LAYERS");

    /**
     * A set of ILayer instances identifying the layers the element containing
     * this hint can be considered to be focusable on.
     */
    public static final Key KEY_FOCUS_LAYERS = new KeyOf(Set.class, "FOCUS_LAYERS");

    /**
     * Properties map
     */
    public static final Key KEY_ELEMENT_PROPERTIES = new KeyOf(Properties.class, "ELEMENT_PROPERTIES");

    /**
     * Color filter to be applied when rendering nodes.
     */
    public static final Key KEY_COLOR_FILTER = new KeyOf(ColorFilter.class, "COLOR_FILTER");

    public static class Properties extends HashMap<String, Object> {
        private static final long serialVersionUID = 6986415032113675720L;
    }

    /**
     * A base class for keys that are to be considered discardable in
     * synchronization.
     */
    public static class DiscardableKey extends KeyOf {
        public DiscardableKey(Class<?> clazz) {
            super(clazz);
        }
        public DiscardableKey(Class<?> clazz, String string) {
            super(clazz, string);
        }
    }

}
