/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.handler.impl;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;

/**
 * @author Toni Kalajainen
 */
public class DataElementMapImpl implements DataElementMap {

	@Override
	public Object getData(IDiagram d, IElement element) {
		assert(ElementUtils.getDiagram(element) == d);
		return element.getHint(ElementHints.KEY_OBJECT);
	}

	@Override
	public IElement getElement(IDiagram d, Object data) {
		for (IElement e : d.getElements())
		{
			Object ed = e.getHint(ElementHints.KEY_OBJECT); 
			if (ed!=null && ed.equals(data))
				return e;
		}
		return null;
	}


}
