/*******************************************************************************
 * Copyright (c) 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui.prefs;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.document.ui.Activator;

/**
 * @author Tuukka Lehtonen
 */
public class DocumentsPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

	public DocumentsPreferencePage() {
		super(GRID);
	}

	@Override
	public void init(IWorkbench workbench) {
	}

	@Override
	protected IPreferenceStore doGetPreferenceStore() {
		return new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.PLUGIN_ID);
	}

	@Override
	protected void createFieldEditors() {
		BooleanFieldEditor f = new BooleanFieldEditor(DocumentsPreferences.P_PREFER_EXTERNAL_EDITOR_FOR_DOCUMENTS, "Prefer External Editor for opening embedded documents", getFieldEditorParent()); //$NON-NLS-1$
		addField(f);
	}

}
