/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.swt.core.widget;

import java.util.TreeMap;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.base.HasWidgetsWidgetManager;
import org.simantics.document.swt.core.base.WidgetContainer;

public class FillComposite extends HasWidgetsWidgetManager<Composite> {

	@Override
	protected void doUpdateProperties(SWTDocument document, Composite control, JSONObject object) {
	}

	@Override
	protected Composite doCreateControl(SWTDocument document, Composite parent, JSONObject object) {
		Composite result = new Composite(parent, SWT.NONE);
//		result.setLayout(new FillLayout(SWT.VERTICAL));
		//GridDataFactory.fillDefaults().grab(true, true).minSize(1, 1).applyTo(result);
		GridLayoutFactory.fillDefaults().applyTo(result);
//		result.setBackground(parent.getDisplay().getSystemColor(SWT.COLOR_RED));
		return result;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void updateChildren(SWTDocument document, JSONObject object, WidgetContainer widget, TreeMap<String, WidgetData> childMap) {

		super.updateChildren(document, object, widget, childMap);

		WidgetData child = childMap.values().iterator().next();
		WidgetContainer container = (WidgetContainer)child.widget;
		if(container.getControl() == null) return;
		GridDataFactory.fillDefaults().grab(true, true).minSize(1, 1).applyTo((Control)container.getControl());

	}

}
