/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.swt.core.base;

import org.simantics.document.server.io.AbstractEventHandler;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandContextImpl;
import org.simantics.document.server.io.CommandContextMutable;
import org.simantics.document.swt.core.SWTDocument;

public class PostEventCommand extends AbstractEventCommand {
    
    private AbstractEventHandler handler;
    private CommandContextMutable context;
    
    public PostEventCommand(SWTDocument document, AbstractEventHandler handler, CommandContextMutable context) {
        this(document, handler, context, null);
    }
    
    public PostEventCommand(SWTDocument document, AbstractEventHandler handler, CommandContextMutable context, PostEventCommand next) {
        super(document);
        assert(handler != null);
        this.handler = handler;
        this.context = context;
        this.next = next;
    }

    @Override
    public CommandContext handleCommand(CommandContextMutable context) {
        CommandContextMutable mergedContext = new CommandContextImpl().merge(context)
                .merge(this.context);
        document.post(handler, mergedContext);
        return context;
    }

    @Override
    public CommandContext commandSuccess(CommandContextMutable context) {
        if(next != null)
            return next.handleCommand(context);
        return context;
    }

    @Override
    public void commandError(String errorMessage) {
        System.err.println(this + " failed: " + errorMessage);
    }

}
