/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.scl.AbstractExpressionCompilationContext;
import org.simantics.db.layer0.scl.AbstractExpressionCompilationRequest;
import org.simantics.db.request.Read;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.structural2.scl.FindPossibleComponentTypeRequest;
import org.simantics.utils.datastructures.Pair;

public abstract class ServerSCLValueRequestBase<CompilationContext extends AbstractExpressionCompilationContext>
extends AbstractExpressionCompilationRequest<CompilationContext, Object> {
    static Pair<Resource, Resource> getComponentTypeAndRoot(ReadGraph graph, Resource component, Resource literal) throws DatabaseException {
        if (component != null) {
            Resource type = (Resource)graph.syncRequest((Read)new FindPossibleComponentTypeRequest(component));
            if (type != null) {
                Resource root = (Resource)graph.syncRequest((Read)new IndexRoot(type));
                return Pair.make((Object)type, (Object)root);
            }
            Resource doc = (Resource)graph.syncRequest((Read)new PossibleTypedParent(component, DocumentationResource.getInstance((ReadGraph)graph).Document));
            if (doc != null) {
                Resource componentType = graph.getSingleType(doc);
                Resource root = (Resource)graph.syncRequest((Read)new IndexRoot(doc));
                return Pair.make((Object)componentType, (Object)root);
            }
            Resource root = (Resource)graph.syncRequest((Read)new IndexRoot(component));
            return Pair.make(null, (Object)root);
        }
        if (literal != null) {
            Resource root = (Resource)graph.syncRequest((Read)new IndexRoot(literal));
            return Pair.make(null, (Object)root);
        }
        throw new DatabaseException("Couldn't resolve component type and root for component == null && literal == null");
    }
}

