/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.templates.custom;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.report.DocumentLine;
import org.simantics.document.linking.report.evaluator.EvaluatorItem;
import org.simantics.document.linking.report.templates.custom.CustomizableContent;
import org.simantics.document.linking.utils.SourceLinkUtil;

public class EvaluatorCustomizableContent
implements CustomizableContent {
    String description;
    EvaluatorItem item;
    boolean supportStyles = false;
    boolean supportMultiline = true;

    public EvaluatorCustomizableContent(String description) {
        this.description = description;
    }

    @Override
    public String getCustomizationDescription() {
        return this.description;
    }

    @Override
    public String getContent(ReadGraph graph, Resource resource, Map<Object, Object> context) throws DatabaseException {
        if (!SourceLinkUtil.isValidReference(graph, resource)) {
            return "Deleted reference";
        }
        Variable variable = (Variable)graph.adapt(resource, Variable.class);
        return this.item.getValue(graph, variable, context);
    }

    @Override
    public List<DocumentLine> getLines(ReadGraph graph, Resource resource, Map<Object, Object> context) throws DatabaseException {
        if (!SourceLinkUtil.isValidReference(graph, resource)) {
            return Collections.singletonList(new DocumentLine("Deleted reference", new Object[0]));
        }
        Variable variable = (Variable)graph.adapt(resource, Variable.class);
        return this.item.getLines(graph, variable, context);
    }

    public void setItem(EvaluatorItem item) {
        this.item = item;
    }

    public EvaluatorItem getItem() {
        return this.item;
    }

    public boolean isSupportStyles() {
        return this.supportStyles;
    }

    public void setSupportStyles(boolean supportStyles) {
        this.supportStyles = supportStyles;
    }

    public boolean isSupportMultiline() {
        return this.supportMultiline;
    }

    public void setSupportMultiline(boolean supportMultiline) {
        this.supportMultiline = supportMultiline;
    }
}

