/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.templates;

import java.util.Comparator;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.layer0.Layer0;
import org.simantics.utils.strings.AlphanumComparator;

class ResourceNameComparator
implements Comparator<Resource> {
    protected ReadGraph graph;
    protected Layer0 l0;
    protected Resource model;

    public ResourceNameComparator(ReadGraph graph, Resource model) {
        this.graph = graph;
        this.l0 = Layer0.getInstance((ReadGraph)graph);
        this.model = model;
    }

    @Override
    public int compare(Resource r1, Resource r2) {
        int c;
        block6: {
            block7: {
                if (r1.equals(r2)) {
                    return 0;
                }
                try {
                    String l1 = this.getText(r1);
                    String l2 = this.getText(r2);
                    c = AlphanumComparator.COMPARATOR.compare((Object)l1, (Object)l2);
                    if (c != 0) break block6;
                    if (r1.getResourceId() <= r2.getResourceId()) break block7;
                    return 1;
                }
                catch (DatabaseException databaseException) {
                    return 0;
                }
            }
            if (r1.getResourceId() < r2.getResourceId()) {
                return -1;
            }
            return 0;
        }
        return c;
    }

    public String getText(Resource r) throws DatabaseException {
        String l1 = NameUtils.getSafeLabel((ReadGraph)this.graph, (Resource)r);
        if (l1.length() == 0) {
            l1 = NameUtils.getSafeName((ReadGraph)this.graph, (Resource)r);
        }
        return l1;
    }

    public List<Resource> getPath(Resource obj) throws DatabaseException {
        return SourceLinkUtil.getPath(this.graph, this.model, obj);
    }
}

