/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.templates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.DocumentResource;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.DocumentTitlePage;
import org.simantics.document.linking.report.RowContentProvider;
import org.simantics.document.linking.report.Table;
import org.simantics.document.linking.report.TextItem;
import org.simantics.document.linking.report.templates.DocumentWriter;
import org.simantics.document.linking.report.templates.ResourceNameComparator;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;

public class ModelDocumentWriter
extends DocumentWriter<List<Resource>> {
    ReadGraph graph;
    Layer0 l0;
    Resource model;
    Map<Object, Object> context;
    Comparator<Resource> comparator;

    @Override
    public String getName() {
        return "Model Internal Documents";
    }

    @Override
    public void start(ReadGraph graph, Resource model, Document lineWriter, Map<Object, Object> context) throws Exception {
        super.start(graph, model, lineWriter, context);
        this.context = context;
        this.model = model;
        DocumentTitlePage titlePage = lineWriter.newElement(DocumentTitlePage.class, new String[0]);
        titlePage.writeTitle(graph, context);
        Table table = lineWriter.newElement(Table.class, new String[0]);
        table.addColumn("Folder", 0.4);
        table.addColumn("Document", 0.6);
        this.graph = graph;
        this.l0 = Layer0.getInstance((ReadGraph)graph);
        this.clearProviders();
        this.addCellProvider(new HierarchyContentProvider());
        this.addCellProvider(new DocumentContentProvider());
    }

    @Override
    public List<List<Resource>> getReportItems(ReadGraph graph) throws DatabaseException {
        this.comparator = new ResourceNameComparator(graph, this.model);
        ArrayList<List<Resource>> result = new ArrayList<List<Resource>>();
        List<Resource> root = Collections.singletonList(this.model);
        this.collect(graph, root, result);
        return result;
    }

    private void collect(ReadGraph graph, List<Resource> location, List<List<Resource>> result) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
        Resource lastInPath = location.get(location.size() - 1);
        ArrayList set = new ArrayList();
        set.addAll(graph.getObjects(lastInPath, l0.ConsistsOf));
        Collections.sort(set, this.comparator);
        for (Resource r : set) {
            ArrayList<Resource> path = new ArrayList<Resource>(location.size() + 1);
            path.addAll(location);
            path.add(r);
            if (graph.isInstanceOf(r, doc.Document)) {
                result.add(path);
                this.collect(graph, path, result);
                continue;
            }
            if (graph.isInstanceOf(r, sr.Component)) continue;
            this.collect(graph, path, result);
        }
    }

    private String getText(List<Resource> current, boolean indent) throws DatabaseException {
        String text = "";
        if (indent) {
            int i = 0;
            while (i < current.size() - 1) {
                text = String.valueOf(text) + "  ";
                ++i;
            }
        }
        text = String.valueOf(text) + NameUtils.getSafeLabel((ReadGraph)this.graph, (Resource)current.get(current.size() - 1));
        return text;
    }

    private int folderIndex(List<Resource> path) throws DatabaseException {
        int i = path.size() - 1;
        while (i >= 0) {
            if (!this.graph.isInstanceOf(path.get(i), this.doc.Document)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private int revisionIndex(Resource document) throws DatabaseException {
        Resource r = document;
        int i = -1;
        while (r != null) {
            Resource r2 = this.graph.getPossibleObject(r, this.l0.PartOf);
            r = this.graph.getPossibleObject(r, this.doc.HasNewerVersion);
            ++i;
            if (r2 != null && !r2.equals(r)) break;
        }
        return i;
    }

    private class DocumentContentProvider
    implements RowContentProvider<List<Resource>> {
        private DocumentContentProvider() {
        }

        @Override
        public void setText(Document writer, List<Resource> previous, List<Resource> current, List<Resource> next, TextItem[] row) throws Exception {
            String s = "";
            Resource document = current.get(current.size() - 1);
            int rev = ModelDocumentWriter.this.revisionIndex(document);
            int i = 0;
            while (i < rev) {
                s = String.valueOf(s) + "  ";
                ++i;
            }
            row[1] = ModelDocumentWriter.this.getDocumentItem(document);
            row[1].setText(String.valueOf(s) + row[1].getText());
        }
    }

    private class HierarchyContentProvider
    implements RowContentProvider<List<Resource>> {
        private HierarchyContentProvider() {
        }

        @Override
        public void setText(Document writer, List<Resource> previous, List<Resource> current, List<Resource> next, TextItem[] text) throws Exception {
            int i;
            int writeFolder = 0;
            int fic = ModelDocumentWriter.this.folderIndex(current);
            if (previous == null) {
                writeFolder = fic + 1;
            } else {
                int fip = ModelDocumentWriter.this.folderIndex(previous);
                if (fip < fic) {
                    writeFolder = fic - fip;
                } else if (fip == fic) {
                    i = 0;
                    while (i <= fic) {
                        if (!previous.get(i).equals(current.get(i))) {
                            writeFolder = previous.size() - i;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (writeFolder > 0) {
                text[0] = writer.newItem(TextItem.class, new String[0]);
                if (writeFolder > 1) {
                    Table table = writer.getCurrentElement(Table.class);
                    i = current.size() - writeFolder + 1;
                    while (i < current.size() - 1) {
                        text[0].setText(ModelDocumentWriter.this.getText(current.subList(0, i), true));
                        text[1] = null;
                        table.writeRowItem(text);
                        ++i;
                    }
                }
                text[0].setText(ModelDocumentWriter.this.getText(current.subList(0, fic + 1), true));
            } else {
                text[0] = null;
            }
        }
    }
}

