/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.simantics.document.linking.report.pdf.PDFPageStream;

public class PDFPage {
    public PDFPageStream stream;
    public Graphics2D g2d;
    public Document document;
    public PdfWriter writer;
    public File tempFile;
    public PdfContentByte cb;
    public PdfTemplate template = null;
    public Font font;
    FontRenderContext frc;
    FontMetrics fm;
    int currentPixel = 0;
    int currentLine = 0;
    int availableLines = 0;

    public PDFPage(PDFPageStream stream) throws Exception {
        this.stream = stream;
        Rectangle pageSize = stream.getPageSize();
        this.document = new Document(pageSize);
        this.tempFile = File.createTempFile("ReportGenerator", ".pdf");
        this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)new FileOutputStream(this.tempFile));
        this.document.open();
        this.cb = this.writer.getDirectContent();
        this.writer.flush();
        this.template = this.cb.createTemplate(pageSize.getWidth(), pageSize.getHeight());
        this.g2d = this.template.createGraphics(pageSize.getWidth(), pageSize.getHeight());
        this.g2d.translate(stream.marginLeft, stream.marginTop);
        this.g2d.setClip(0, 0, stream.contentWidth, stream.contentHeight);
        this.currentPixel = 0;
        this.currentLine = 1;
        this.setFont(stream.getDefaultFont());
    }

    protected int getLineHeight() {
        return this.fm.getHeight();
    }

    public boolean isOpen() {
        return this.template != null;
    }

    public void setFont(Font font) {
        this.font = font;
        this.g2d.setFont(font);
        this.fm = this.g2d.getFontMetrics();
        this.frc = new FontRenderContext(this.g2d.getTransform(), true, true);
        this.estimateAvailableLines();
    }

    protected void estimateAvailableLines() {
        this.availableLines = (int)Math.floor((this.stream.contentHeight - this.currentPixel) / this.getLineHeight());
    }

    public Font getFont() {
        return this.font;
    }

    public void writeLine(String line) throws Exception {
        this.writeLine(line, 0);
    }

    public void writeLine(String line, int x) throws Exception {
        this.g2d.drawString(line, x, this.currentPixel + this.getLineHeight());
        ++this.currentLine;
        --this.availableLines;
        this.currentPixel += this.getLineHeight();
        this.stream.checkNextPage();
    }

    public void close() {
        this.g2d.dispose();
        this.cb.addTemplate(this.template, 0.0f, 0.0f);
        this.template = null;
        this.document.close();
        if (this.writer != null) {
            this.writer.close();
        }
        this.document = null;
        this.writer = null;
        this.cb = null;
        this.g2d = null;
    }
}

