/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.pdf;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.DocumentElement;
import org.simantics.document.linking.report.DocumentItem;
import org.simantics.document.linking.report.DocumentTitlePage;
import org.simantics.document.linking.report.Table;
import org.simantics.document.linking.report.TableOfContents;
import org.simantics.document.linking.report.TextItem;
import org.simantics.document.linking.report.URLItem;
import org.simantics.document.linking.report.base.TextItemImpl;
import org.simantics.document.linking.report.base.URLItemImpl;
import org.simantics.document.linking.report.pdf.PDFPageStream;
import org.simantics.document.linking.report.pdf.PDFTable;
import org.simantics.document.linking.report.pdf.PDFTitlePage;
import org.simantics.document.linking.report.pdf.PDFTocElement;
import org.simantics.utils.datastructures.Arrays;

public class PDFDocument
implements Document {
    private String filename;
    Map<Document.TextSize, Font> fonts = new HashMap<Document.TextSize, Font>();
    PDFPageStream contentStream;
    PDFTable currentTable;
    PDFTitlePage titlePage;
    PDFTocElement toc;

    public PDFDocument(String filename) throws Exception {
        this.filename = filename;
        this.contentStream = new PDFPageStream();
        this.defaultFonts();
        this.contentStream.setDefaultFont(this.fonts.get((Object)Document.TextSize.SMALL));
    }

    public PDFDocument(String filename, Font font) throws Exception {
        this.filename = filename;
        this.contentStream = new PDFPageStream();
        this.defaultFonts();
        this.fonts.put(Document.TextSize.SMALL, font);
    }

    public PDFDocument(String filename, Font font, Font headerFont) throws Exception {
        this.filename = filename;
        this.contentStream = new PDFPageStream();
        this.defaultFonts();
        this.fonts.put(Document.TextSize.SMALL, font);
        this.fonts.put(Document.TextSize.MEDIUM, headerFont);
    }

    private void defaultFonts() {
        this.fonts.put(Document.TextSize.TINY, new Font("Arial", 0, 6));
        this.fonts.put(Document.TextSize.SMALL, new Font("Arial", 0, 8));
        this.fonts.put(Document.TextSize.MEDIUM, new Font("Arial", 0, 10));
        this.fonts.put(Document.TextSize.LARGE, new Font("Arial", 0, 16));
        this.fonts.put(Document.TextSize.HUGE, new Font("Arial", 1, 24));
        this.contentStream.setDefaultFont(this.fonts.get((Object)Document.TextSize.SMALL));
    }

    Font getFont(Document.TextSize size) {
        return this.fonts.get((Object)size);
    }

    @Override
    public int getAvailableLines() {
        return this.contentStream.getAvailableLines();
    }

    @Override
    public int getCurrentLine() {
        return this.contentStream.getCurrentLine();
    }

    @Override
    public void close() throws Exception {
        if (this.toc != null) {
            this.toc.create(this.contentStream, this.contentStream.getPages().get(0));
        }
        this.contentStream.close(this.filename);
    }

    @Override
    public void nextPage() throws Exception {
        this.contentStream.nextPage();
    }

    @Override
    public <T extends DocumentElement> T newElement(Class<T> cls, String ... options) throws Exception {
        if (cls == Table.class) {
            return (T)this.newTable();
        }
        if (cls == TableOfContents.class) {
            return (T)this.getOrCreateToc();
        }
        if (cls == DocumentTitlePage.class) {
            if (this.titlePage != null) {
                throw new Exception("Report may contain only one title page");
            }
            this.titlePage = new PDFTitlePage(this);
            return (T)this.titlePage;
        }
        return null;
    }

    @Override
    public <T extends DocumentElement> T nextElement(Class<T> cls, String ... options) throws Exception {
        if (cls == Table.class) {
            return (T)this.nextTable(Arrays.contains((Object[])options, (Object)"toc"));
        }
        if (cls == TableOfContents.class) {
            return (T)this.getOrCreateToc();
        }
        return null;
    }

    @Override
    public <T extends DocumentElement> T getCurrentElement(Class<T> cls) {
        if (cls == Table.class) {
            return (T)this.getCurrentTable();
        }
        if (cls == TableOfContents.class) {
            return (T)this.toc;
        }
        if (cls == DocumentTitlePage.class) {
            return (T)this.titlePage;
        }
        return null;
    }

    @Override
    public <T extends DocumentItem> T newItem(Class<T> cls, String ... options) throws Exception {
        if (cls == TextItem.class) {
            return (T)new TextItemImpl();
        }
        if (cls == URLItem.class) {
            return (T)new URLItemImpl();
        }
        return null;
    }

    public Table nextTable(boolean id) throws Exception {
        if (this.currentTable != null) {
            this.closeTable();
            this.currentTable = new PDFTable(this.currentTable);
            return this.currentTable;
        }
        return this.newTable();
    }

    private void closeTable() throws Exception {
        if (this.currentTable != null && this.currentTable.currentLine > 0) {
            this.currentTable.setLinesVisible(false);
            this.currentTable.setHeaderVisible(false);
            this.currentTable.writeLine("");
        }
    }

    public Table newTable() throws Exception {
        this.closeTable();
        this.currentTable = new PDFTable(this, this.contentStream);
        return this.currentTable;
    }

    Table getCurrentTable() {
        return this.currentTable;
    }

    TableOfContents getOrCreateToc() throws Exception {
        if (this.toc == null) {
            this.toc = new PDFTocElement(this);
        }
        return this.toc;
    }
}

