package org.simantics.document.linking.report.templates.custom;

import java.util.List;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.linking.report.DocumentLine;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.reporting.AbstractSCLReportingHandler;



/**
 * SCL-script based customization
 * 
 * NOTE: this does not work, since at the moment the CommandSession is not able to attach itself to given read transaction.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class SCLCustomizableContent implements CustomizableContent {
	
	private CommandSession session;
	private String sclCode[];
	
	private String label;
	
	public SCLCustomizableContent(String label) {
		session = new CommandSession(SCLOsgi.MODULE_REPOSITORY, null);
		
		sclCode = new String[]{"import \"Simantics/Ontologies\"", //$NON-NLS-1$
		                       "nameOfResource r = match possibleRelatedValue r L0.HasName with\n"+ //$NON-NLS-1$
                               "    Just name -> name\n"+ //$NON-NLS-1$
                               "    Nothing -> \"no name\"", //$NON-NLS-1$
                               "nameOfResource res"};                           //$NON-NLS-1$
	}
	
	@Override
	public String getCustomizationDescription() {
		return label;
	}
	
	@Override
	public String getContent(ReadGraph graph, Resource resource, Map<Object, Object> context)
			throws DatabaseException {
		
		session.setVariable("res", Types.con("Simantics/DB", "Resource"), resource); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		final StringBuilder responseBuilder = new StringBuilder();
		final StringBuilder errorBuilder = new StringBuilder();
		for (String code : sclCode) {
			session.execute(code, new AbstractSCLReportingHandler() {
                
                @Override
                public void print(String text) {
                    responseBuilder.append(text).append('\n');
                }
                
                @Override
                public void printError(String error) {
                    errorBuilder.append(error).append('\n');
                }
                
                @Override
                public void printCommand(String command) {
                }
            });
			if(errorBuilder.length() > 0)
			    throw new DatabaseException("Error executing SCL \"" + code + "\" " + errorBuilder.toString().trim()); //$NON-NLS-1$ //$NON-NLS-2$
		}
		return responseBuilder.toString().trim();
	}
	
	@Override
	public List<DocumentLine> getLines(ReadGraph graph, Resource resource, Map<Object, Object> context)
			throws DatabaseException {
		// TODO Auto-generated method stub
		return null;
	}
	
	public String[] getSclCode() {
		return sclCode;
	}
	
	public void setSclCode(String[] sclCode) {
		this.sclCode = sclCode;
	}
	

}
