package org.simantics.document.linking.report.templates;

import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.modeling.ModelingResources;

class SourceParentDiagramComparator extends ResourceNameComparator {
	DocumentLink sl;
	ModelingResources mod;
	
	public SourceParentDiagramComparator(ReadGraph graph, Resource model) {
		super(graph,model);
		sl = DocumentLink.getInstance(graph);
		mod = ModelingResources.getInstance(graph);
	}
	
	
	@Override
	public int compare(Resource o1, Resource o2) {
		try {
			Resource r1 = graph.getSingleObject(o1, sl.hasSource_Inverse);
			Resource r2 = graph.getSingleObject(o2, sl.hasSource_Inverse);
			List<Resource> path1 = getPath(r1);
			List<Resource> path2 = getPath(r2);
			int diag1 = -1;
			int diag2 = -1;
			for (int i = path1.size() -1; i >= 0; i--) {
				if (graph.hasStatement(path1.get(i),mod.CompositeToDiagram)) {
					diag1 = i;
					break;
				}
			}
			for (int i = path2.size() -1; i >= 0; i--) {
				if (graph.hasStatement(path2.get(i),mod.CompositeToDiagram)) {
					diag2 = i;
					break;
				}
			}
			int count = Math.min(diag1, diag2);
			
			int i = 0;
			int comp = 0;
			for (; i <= count; i++) {
				comp = super.compare(path1.get(i), path2.get(i));
				if (comp != 0)
					return comp;
			}
			return diag1 - diag2;
			
		} catch (Exception e) {
			return 0;
		}
		
	}
}