package org.simantics.document.linking.report.pdf;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

import org.simantics.document.linking.report.DocumentElement;
import org.simantics.document.linking.report.TableOfContents;
import org.simantics.document.linking.report.Document.TextSize;
import org.simantics.document.linking.report.TableColumn.Alignment;
import org.simantics.utils.datastructures.Pair;


public class PDFTocElement implements TableOfContents {
	
	PDFDocument writer;
	PDFPageStream stream;
	
	Font itemFont;
	Font titleFont;
	
	int linesPerPage;
	int linesOnFirstPage;
	
	PDFTable tocTable;
	
	public PDFTocElement(PDFDocument writer) throws Exception{
		this.writer = writer;
		stream = new PDFPageStream();
		itemFont = writer.getFont(TextSize.SMALL);
		titleFont = writer.getFont(TextSize.LARGE);
		stream.setDefaultFont(itemFont);
		
		stream.nextPage();
		tocTable= new PDFTable(writer, stream);
		linesPerPage = tocTable.getAvailableLines();
		//linesPerPage = stream.getAvailableLines();
		PDFPage page = stream.getCurrentPage();
		page.setFont(titleFont);
		page.writeLine(Messages.PDFTocElement_TocHeading);
		page.setFont(itemFont);
		page.writeLine(""); //$NON-NLS-1$
		linesOnFirstPage = tocTable.getAvailableLines();
		//linesOnFirstPage = page.availableLines;
	}
	private List<Pair<String, PDFElement>> toc = new ArrayList<Pair<String,PDFElement>>();
	@Override
	public void addTocElement(String label, DocumentElement element) {
		toc.add(new Pair<String, PDFElement>(label, (PDFElement)element));
	}
	
	public void create(PDFPageStream destStream, PDFPage after) throws Exception {
		int tocPages = getEstimatedPages();

		List<PDFPage> pages = destStream.getPages();
		int tocIndex = pages.indexOf(after)+1;
		
		tocTable.addColumn("Document", 0.9); //$NON-NLS-1$
		tocTable.addColumn("Page", 0.1).setAlignment(Alignment.RIGHT); //$NON-NLS-1$
		tocTable.setHeaderVisible(false);
		tocTable.setLinesVisible(false);
		for (Pair<String, PDFElement> item : toc) {
			int pageIndex = pages.indexOf(item.second.getPage());
			if (pageIndex >= 0) {
				pageIndex += tocPages + 1;
			}
			tocTable.writeRow(item.first, Integer.toString(pageIndex));
//			stream.getCurrentPage().writeLine( + "  " + pageIndex);
		}
		
		pages.addAll(tocIndex, stream.getPages());
		stream = null;
	}
	
	
	
	public int getEstimatedPages() {
		int pages = 1;
		int items = toc.size();
		items -= linesOnFirstPage;
		while (items > 0) {
			items-= linesPerPage;
			pages++;
		}
		return pages;
	}

}
