package org.simantics.document.linking.report.html;

import org.simantics.document.linking.report.DocumentElement;
import org.simantics.document.linking.report.TableOfContents;


public class HTMLTocElement extends HTMLStreamElement implements TableOfContents {
	
	

	HTMLTable tocTable;
	
	public HTMLTocElement(HTMLDocument writer) throws Exception{
		super(writer);
		this.os.println(Messages.HTMLTocElement_TocHeading);
		tocTable = new HTMLTable(writer, os, false);
		tocTable.setHeaderVisible(false);
		tocTable.setLinesVisible(false);
		tocTable.addColumn("Name", 1.0); //$NON-NLS-1$
	}
	
	@Override
	public void addTocElement(String label, DocumentElement element) throws Exception{
		HTMLElement e = (HTMLElement)element;
		if (e.getId() == null)
			throw new IllegalArgumentException("Element has no id " + element); //$NON-NLS-1$
		//os.println("<a href=\"#" + e.getId() + "\">" + label + "</a><br>");
		tocTable.writeRow("<a href=\"#" + e.getId() + "\">" + label + "</a><br>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	}
	
	public void close() throws Exception{
		tocTable.endTable();
		os.print("<br>"); //$NON-NLS-1$
		super.close();
	}
	
	@Override
	public String getId() {
		return "toc"; //$NON-NLS-1$
	}

}
