package org.simantics.document.linking.report.evaluator;

import java.util.ArrayList;
import java.util.List;

import org.simantics.objmap.graph.annotations.OrderedElementsAdd;
import org.simantics.objmap.graph.annotations.OrderedElementsGet;
import org.simantics.objmap.graph.annotations.OrderedElementsRem;

public abstract class EvaluatorNode implements EvaluatorItem{
	
	EvaluatorNode parent;
	
	List<EvaluatorItem> children = new ArrayList<EvaluatorItem>();
	
	
	@Override
	public EvaluatorNode getParent() {
		return parent;
	}
	
	@Override
	public void setParent(EvaluatorNode parent) {
		this.parent = parent;
	}
	
	@OrderedElementsGet
	public List<EvaluatorItem> getChildren() {
		return children;
	}
	
	public boolean acceptChild(EvaluatorItem item) {
		return true;
	}
	
	public boolean acceptChild(int index, EvaluatorItem item) {
		return true;
	}
	
	public void addChild(EvaluatorItem item) {
		children.add(item);
		item.setParent(this);
	}
	
	@OrderedElementsAdd
	public void addChild(int index, EvaluatorItem item) {
		children.add(index, item);
		item.setParent(this);
	}
	
	public int indexOf(EvaluatorItem item) {
		return children.indexOf(item);
	}
	
	@OrderedElementsRem
	public void removeChild(EvaluatorItem item) {
		children.remove(item);
		item.setParent(null);
	}
	
	
	public List<Class<? extends EvaluatorItem>> getPossibleChildren(boolean add) {
		List<Class<? extends EvaluatorItem>> classes = new ArrayList<Class<? extends EvaluatorItem>>();
		classes.add(And.class);
		classes.add(Or.class);
		classes.add(If.class);
		classes.add(Constant.class);
		classes.add(Variable.class);
		classes.add(Date.class);
		classes.add(Path.class);
		EvaluatorRoot root = getRoot();
		if (root != null && root.isSupportStyles()) {
			classes.add(TextSizeHint.class);
			classes.add(AlignmentHint.class);
		}
		
		return classes;
	}
	
	@SuppressWarnings("unchecked")
	public <T extends EvaluatorItem> T createChild(Class<T> cls) {
		EvaluatorItem child;
		try {
			child = cls.newInstance();
			if (child instanceof EvaluatorNode)
				((EvaluatorNode)child).parent = this;
			else if (child instanceof EvaluatorLeaf) {
				((EvaluatorLeaf)child).parent = this;
			}
			addChild(child);
			return (T)child;
		} catch (Exception e) {
			
		} 
		return null;
	}
	
	@SuppressWarnings("unchecked")
	public <T extends EvaluatorItem> T createChild(int index, Class<T> cls) {
		EvaluatorItem child;
		try {
			child = cls.newInstance();
			if (child instanceof EvaluatorNode)
				((EvaluatorNode)child).parent = this;
			else if (child instanceof EvaluatorLeaf) {
				((EvaluatorLeaf)child).parent = this;
			}
			addChild(child);
			return (T)child;
		} catch (Exception e) {
			
		} 
		return null;
		
	}
	
	@Override
	public EvaluatorRoot getRoot() {
		if (parent == null)
			return null;
		return parent.getRoot();
	}
	
	protected void copyChildren(EvaluatorNode copy) {
		for (EvaluatorItem i : children) {
			copy.addChild(i.copy());
		}
	}

}
