/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization;

import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * A graph synchronizer for hint changes in diagram elements.
 * 
 * @author Tuukka Lehtonen
 * @see ISynchronizationContext
 * @see SynchronizationHints
 * @see IModificationQueue
 * @see IHintObservable
 */
public interface IHintSynchronizer {

    /**
     * Makes sure the provided observable (element) if properly synchronized into the graph.
     * 
     * @param context
     * @param observable
     * @return
     */
    int synchronize(ISynchronizationContext context, IHintObservable observable);

    /**
     * @param queue an interface for dispatching modifications (see
     *        {@link IModification}) for synchronizing the model according to
     *        the hint changes
     * @param sender the observable in which the hint has changed
     * @param key the key of the changed hint
     * @param oldValue the previous hint value
     * @param newValue the new hint value, must be non-null
     * @return <code>true</code> if the modification was processed by this
     *         synchronizer, <code>false</code> otherwise
     */
    boolean hintChanged(ISynchronizationContext context, IHintObservable sender, Key key, Object oldValue, Object newValue);

    /**
     * @param queue an interface for dispatching modifications (see
     *        {@link IModification}) for synchronizing the model according to
     *        the hint changes
     * @param sender the observable in which the hint has changed
     * @param key the key of the changed hint
     * @param oldValue the previous hint value
     * @return <code>true</code> if the modification was processed by this
     *         synchronizer, <code>false</code> otherwise
     */
    boolean hintRemoved(ISynchronizationContext context, IHintObservable sender, Key key, Object oldValue);

}
