package org.simantics.diagram.participant;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil.TerminalInfo;
import org.simantics.g2d.elementclass.BranchPoint.Direction;

/**
 * @author Tuukka Lehtonen
 */
public class ControlPoint {

    private final Point2D position           = new Point2D.Double();
    private Direction     direction;
    private TerminalInfo  attachedToTerminal = null;

    public ControlPoint(Point2D pos) {
        this(pos, Direction.Any);
    }

    public ControlPoint(Point2D pos, Direction direction) {
        this.position.setLocation(pos);
        this.direction = direction;
    }

    public ControlPoint setPosition(Point2D position) {
        this.position.setLocation(position);
        return this;
    }

    public ControlPoint setPosition(double x, double y) {
        this.position.setLocation(x, y);
        return this;
    }

    /**
     * Take the control point position from the translation part of the
     * specified AffineTransform.
     * 
     * @param at
     * @return
     */
    public ControlPoint setPosition(AffineTransform at) {
        this.position.setLocation(at.getTranslateX(), at.getTranslateY());
        return this;
    }

    public ControlPoint setDirection(Direction direction) {
        if (direction == null)
            throw new NullPointerException("trying to set null direction");
        this.direction = direction;
        return this;
    }

    public ControlPoint setAttachedToTerminal(TerminalInfo info) {
        this.attachedToTerminal = info;
        return this;
    }

    public Direction getDirection() {
        return direction;
    }

    public Point2D getPosition() {
        return new Point2D.Double(position.getX(), position.getY());
    }

    public boolean isAttachedToTerminal() {
        return attachedToTerminal != null;
    }

    public TerminalInfo getAttachedTerminal() {
        return attachedToTerminal;
    }

    @Override
    public String toString() {
        return "[" + position + ", " + direction + ", " + isAttachedToTerminal() + "]";
    }

}