/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.elements;

import org.simantics.diagram.participant.ContextUtil;
import org.simantics.diagram.participant.DiagramCommandBindings;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IMouseCaptureHandle;
import org.simantics.g2d.diagram.participant.ElementInteractor;
import org.simantics.g2d.element.IElement;

/**
 * @author Tuukka Lehtonen
 */
public class TextEditActivation {

    IMouseCaptureHandle capture;
    ContextUtil         ctxUtil;
    
    public static final String DEFAULT_INLINE_EDIT_CONTEXT = "org.simantics.modeling.ui.diagramming.inlineEdit";


    public TextEditActivation(int mouseId, IElement e, ICanvasContext ctx) {
        ElementInteractor ei = ctx.getSingleItem(ElementInteractor.class);
        this.ctxUtil = ctx.getAtMostOneItemOfClass(ContextUtil.class);

        // Capture mouse events (otherwise we would not get mouse events when the cursor is outside the text widget)
        this.capture = ei.captureMouse(e, mouseId);

        if(ctxUtil != null)
            DiagramCommandBindings.activateBindings(ctxUtil, DEFAULT_INLINE_EDIT_CONTEXT);

    }

    public void release() {
        if (capture != null) {
            capture.release();
            capture = null;
        }
        if (ctxUtil != null) {
            DiagramCommandBindings.deactivateBindings(ctxUtil, DEFAULT_INLINE_EDIT_CONTEXT);
            ctxUtil = null;
        }
    }

}
