/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection;

/**
 * @author Tuukka Lehtonen
 */
public enum ConnectionSegmentType {
    CONNECTOR_TO_CONNECTOR,
    CONNECTOR_TO_BRANCH,
    BRANCH_TO_BRANCH;

    public static ConnectionSegmentType toSegmentType(ConnectionSegmentEnd first, ConnectionSegmentEnd second) {
        ConnectionSegmentEnd other = null;
        if (first == ConnectionSegmentEnd.CONNECTOR) {
            other = second;
        } else if (second == ConnectionSegmentEnd.CONNECTOR) {
            other = first;
        } else {
            return ConnectionSegmentType.BRANCH_TO_BRANCH;
        }
        switch (other) {
            case CONNECTOR:
                return ConnectionSegmentType.CONNECTOR_TO_CONNECTOR;
            case BRANCH:
                return ConnectionSegmentType.CONNECTOR_TO_BRANCH;
            default:
                throw new Error("unexpected connection segment end: " + other);
        }
    }
}