package org.simantics.diagram.profile.view;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.utils.strings.StringUtils;

public class SelectedProfile extends ReadFactoryImpl<Resource, String> {

	@Override
	public String perform(ReadGraph graph, Resource runtimeDiagram) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(graph);
		DiagramResource DIA = DiagramResource.getInstance(graph);
		Resource profile = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasRuntimeProfile);
		if(profile == null) return null;
		String name = graph.getPossibleRelatedValue(profile, L0.HasName, Bindings.STRING);
		return StringUtils.safeString(name);
	}

}
